// $Id: CDisplayInformation.cpp,v 1.4 2007/03/03 14:45:32 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDisplayInformation.hpp"
using Exponent::Host::CDisplayInformation;

#ifndef WIN32
#include <ApplicationServices/ApplicationServices.h>
#endif

//	===========================================================================
void CDisplayInformation::dumpDisplayInfoToFile(const CSystemString &path)
{
	// Check the path
	CSystemString myPath = path;

	if (!myPath.hasExtension())
	{
		myPath.appendString("CPUStats.txt");
	}

	// Open the stream
	CTextStream stream(myPath, CTextStream::e_output);

	// Output the values
	dumpDisplayInfoToFile(stream);

	// Close the stream
	stream.closeStream();
}

//	===========================================================================
void CDisplayInformation::dumpDisplayInfoToFile(CTextStream &stream)
{
	if (stream.isStreamOpen())
	{
		stream << "Exponent Host display info extraction tool\n";
		stream << "------------------------------------------\n\n";
		stream << "Number of monitors\t:\t\t" << getNumberOfMonitors() << "\n";
		stream << "Screen width\t\t:\t\t" << getMonitorScreenWidth() << "\n";
		stream << "Screen height\t\t:\t\t" << getMonitorScreenHeight() << "\n";
		stream << "------------------------------------------\n\n";
	}
}

//	===========================================================================
long CDisplayInformation::getNumberOfMonitors()
{
#ifdef WIN32
	return (long)GetSystemMetrics(SM_CMONITORS);
#else
	CGDisplayCount theCount;
	if (CGGetActiveDisplayList(0, NULL, &theCount) == kCGErrorSuccess)
	{
		return (long)theCount;
	}
	return 1;
#endif
}

//	===========================================================================
long CDisplayInformation::getMonitorScreenWidth()
{
#ifdef WIN32
	return (long)GetSystemMetrics(SM_CXSCREEN);
#else
	return (long)CGDisplayPixelsWide(CGMainDisplayID());
#endif
}

//	===========================================================================
long CDisplayInformation::getMonitorScreenHeight()
{
#ifdef WIN32
	return (long)GetSystemMetrics(SM_CYSCREEN);
#else
	return (long)CGDisplayPixelsHigh(CGMainDisplayID());
#endif
}

//	===========================================================================
long CDisplayInformation::getWindowBorderWidth()
{
#ifdef WIN32
	return (long)GetSystemMetrics(SM_CXBORDER);
#else
	return 0;		// N/A on macintosh
#endif
}

//	===========================================================================
long CDisplayInformation::getWindowBorderHeight()
{
#ifdef WIN32
	return (long)GetSystemMetrics(SM_CYBORDER);
#else
	return 0;		// N/A on macintosh
#endif
}